***********************************************
Read CPS Data from ICPSR for 
1968-1972 - All data is downloaded from 
ICPSR - Annual Demographic Files for 1968-1972
Program 1 of 4

5/3/10:  EDITED TO RUN ON JIM'S COMPUTRE (NOTE, PROC COMPARE TO MY CODE FOR 
	     1972 MATCHES EXACTLY
**********************************************;
filename mar68 'C:\Users\jsulliv4\Documents\Jim\CPSdata\1968_Data\07559-0001-Data.txt';
filename mar69 'C:\Users\jsulliv4\Documents\Jim\CPSdata\1969_Data\07560-0001-Data.txt';
filename mar70 'C:\Users\jsulliv4\Documents\Jim\CPSdata\1970_Data\07561-0001-Data.txt'; 
filename mar71 'C:\Users\jsulliv4\Documents\Jim\CPSdata\1971_Data\07562-0001-Data.txt';
filename mar72 'C:\Users\jsulliv4\Documents\Jim\CPSdata\1972_Data\07563-0001-Data.txt';

%macro read(yr,dir);

data cpsdata.cps&yr;
infile &dir missover lrecl=1000;

* DO FIRST FOR NON-1970;
if &yr NE 1970 then do;
input rectype  1 @;
if rectype=4 then famid=_n_;
retain famid;
if rectype=4 then input
ftype    27-28
state2   37-38
fpersons 53-54
fownu18  63-64
ftotval  73-78
ftotearn  79-84
fpovcut  103-108
famlis   109
htotval 91-96
hlivqrt   45-46
frelu18 55-56
hdage 29-30
hdsex 32
hdrace 33
fam_random  6-10
fam_serial  11-15
famwgt 205-216


@;
retain ftype state2 fpersons fownu18 fpovcut ftotval hlivqrt frelu18 famlis ftotearn htotval hdage hdsex hdrace fam_random fam_serial famwgt ;

if rectype=4 and ftype IN(1 2 5) then hhid=_n_;
retain hhid;




if rectype in (1,2,3) then input
age 29-30
sex 32
race2 33
reorgn 197-198
famrel 38
famrel2 41-42
marstat 45
hga  57-58
hgc  59
wkswrk 131
hrslw   153-154 
msupwgt 211-216 
msupwgt3 205-216
rsnnotw   149      
wkswrk   131     
pertype        1
ssinc 85-90
divinc 91-96
welfinc 97-102
uiinc 103-108
alimony 109-114
ptotinc 61-66
totwage 67-72
nonfarminc 73-78
farminc 79-84
rsnnotl 146
random $ 6-10
serial $ 11-15
famnum 40 
fmsecd 39 
;

hhid_1=(fam_random*1000000)+fam_serial;
if fam_random=. then hhid_1=fam_serial;
if fam_serial=. then hhid_1=fam_random;
*According To CPS Utilites information (for hhid or _hhid variable) we can 
attain the correct household ids for individuals only in 1972 using the head of 
a household identifier, this approach will not work for 1968-1971.  Following 
documentation from CPS Utilities we use the random and serial variables (both at the 
family level) to construct the appropriate household ids;
if &yr=1972 then hhid=hhid;
if &yr IN(1968,1969,1971) then hhid=hhid_1;

if age < 14 then ssinc=0;
	  if age < 14 then divinc=0;
	  if age < 14 then welfinc=0;
	  if age < 14 then uiinc=0;
	  if age < 14 then alimony=0;
	  if age < 14 then totwage=0;
	  if age < 14 then nonfarminc=0;
	  if age < 14 then farminc=0;
	  if age < 14 then ptotinc=0;
	  ptotearn=totwage+nonfarminc+farminc;
*Create intinc and retinc and set equal to zero;
intinc=0;
retinc=0;

kid=(age LE 17);
surv_yr=&yr;
ref_year=&yr-1;
if rectype=4 then delete;
if ftype in (8,9) then delete;
if ftype IN(5,6,7) then fpersons=1;
if ftype IN(5,6,7) then fownu18=0;
if ftype IN(5,6,7) then frelu18=0;
*htotvals for individuals in group quarters are set at 99999;
if ftype GE 7 then htotval=ftotval; 
*correct for obs where msupwgt3 is not entered correctly;
if msupwgt3=. then msupwgt3=msupwgt*-1;
end;

* DO FOR 1970;
*We must create a separate approach for 1970 due to its availability from ICPSR website;
if &yr=1970 then do;
INPUT                                                                          
fam_random  14-18              
fam_serial  19-23                          
ftype 35-36               
hdage 37-38              
hdsex 39-39              
hdrace 40-40                            
state2 43-44                            
hlivqrt 56-56              
fpersons 57-58              
frelu18 59-60             
fownu18 67-68              
ftotval 74-79              
ftotearn 80-85                          
htotval 92-97                           
fpovcut 104-109             
famlis 110-110                        
famwgt 125-136 .2                     
pertype 142-142                      
random  147-151            
serial  152-156             
age 170-171                        
sex 173-173            
race2 174-174                        
famrel 179-179             
famnum 180-180            
fmsecd 181-181            
famrel2 182-183             
marstat 186-186                       
hga 195-196            
hgc 197-197             
ptotinc 198-203            
totwage 204-209            
nonfarminc 210-215             
farminc 216-221            
ssinc 222-227            
divinc 228-233             
welfinc 234-239            
uiinc 240-245            
alimony 246-251             
wkswrk 267-267             
rsnnotl 281-281                       
rsnnotw 284-284                        
hrslw 288-289             
msupwgt3 328-339 .2         
famid 340-344     ;  
*According To CPS Utilites information (for hhid or _hhid variable) we can 
attain the correct household ids for individuals only in 1972 using the head of 
a household identifier, this approach will not work for 1968-1971.  Following 
documentation from CPS Utilities we use the random and serial variables (both at the 
family level) to construct the appropriate household ids;
hhid=(fam_random*1000000)+fam_serial;
if fam_random=. then hhid=fam_serial;
if fam_serial=. then hhid=fam_random;

if age < 14 then ssinc=0;
	  if age < 14 then divinc=0;
	  if age < 14 then welfinc=0;
	  if age < 14 then uiinc=0;
	  if age < 14 then alimony=0;
	  if age < 14 then totwage=0;
	  if age < 14 then nonfarminc=0;
	  if age < 14 then farminc=0;
	  if age < 14 then ptotinc=0;
	  ptotearn=totwage+nonfarminc+farminc;
*Create intinc and retinc and set equal to zero;
intinc=0;
retinc=0;

kid=(age LE 17);
surv_yr=&yr;
ref_year=&yr-1;
if ftype in (8,9) then delete;
if ftype IN(5,6,7) then fpersons=1;
if ftype IN(5,6,7) then fownu18=0;
if ftype IN(5,6,7) then frelu18=0;
*htotvals for individuals in group quarters are set at 99999;
if ftype GE 7 then htotval=ftotval; 
end;

run;

PROC SORT DATA=cpsdata.cps&yr;
   BY famid;
RUN;

* FAMILY HEADS;
DATA cpsdata.cps&yr;
  SET cpsdata.cps&yr;
  BY famid; 
  IF FIRST.famid AND ftype NE 4 THEN head=1;
  	ELSE head=0;
RUN;
%mend read;
%read(1968,mar68);
%read(1969,mar69);
%read(1970,mar70);
%read(1971,mar71);
%read(1972,mar72); 


proc compare base=cpsdata.all1972
             compare=cpsdata.cps1972
			 novalues
;
run;
